const mongoose = require('mongoose');

const clientSchema = new mongoose.Schema({
  company: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Company',
    required: true
  },
    name: {
      type: String,
      required: true,
      trim: true
    },
  contactPerson: {
    type: String,
    trim: true
  },
  origin: { 
    type: String, 
    enum: ['internal', 'external'], 
    default: 'internal' 
  },
  email: {
    type: String,
    required: true,
    lowercase: true,
    trim: true
  },
  phone: {
    type: String,
    trim: true
  },
  contactPerson: {
    type: String,
    trim: true
  },
  billingAddress: {
    street: String,
    city: String,
    state: String,
    zipCode: String,
    country: String
  },
  shippingAddress: {
    street: String,
    city: String,
    state: String,
    zipCode: String,
    country: String
  },
  taxId: {
    type: String,
    trim: true
  },
  vatNumber: {
    type: String,
    trim: true
  },
  paymentTerms: {
    type: String,
    default: 'Net 30'
  },
  currency: {
    type: String,
    default: 'USD'
  },
  notes: {
    type: String
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

// Index for searching
clientSchema.index({ name: 'text', email: 'text', contactPerson: 'text' });

module.exports = mongoose.model('Client', clientSchema);